#include <iostream>
#include <iomanip>
#include <malloc.h>
#include "hashtab.h"
#include "utils.h"
#include "squares.h"
#include "defs.h"
#include "log.h"


using namespace std;

const uint MB = 1000000;

cHashtable::cHashtable()
{
 elements = 16;
 init_table_memory();
 reset_tables();
}


void cHashtable::delete_tables()
{
   free(table);
   table = NULL;
}

void cHashtable::makenewtable(const uint elem)
{
     delete_tables();
     elements = elem;
     init_table_memory();
     reset_tables();
}

void cHashtable::init_table_memory()
{
  //get the size of a hash element
  uint tablesize = sizeof(sHashelem);
#ifdef DEBUG
  cout<<"\n";
  cout<<"Table elem size = "<<tablesize<<endl;
#endif

  if(elements<1) {cout<<"\n no hash memory defined for main table, exiting";exit(1);}

  // mulptiply for MB
  elements   *= MB;

  //divide numelem by the elemsize to get the number of elements
  elements /= tablesize;
#ifdef DEBUG
  cout<<"\n";
  cout<<"Num table elements = "<<elements;
#endif

  table = new sHashelem[elements];
  if (table == NULL){cout<<"\n error assigning table";exit(1);}

#ifdef DEBUG
  cout<<"\nTable memory occupation :";
  cout<<" = "<<(_msize(table))/1000<<" kB"<<endl;
#endif

  //reduce element numbers by four to prevent overwriting of the table array
  elements -= 2;

  reset_tables();
}

void cHashtable::reset_tables()
{
   uint i;
   resetcounters();
   for(i = 0; i < elements; ++i)
   {
           table[i].key = 0;
           table[i].move = NULLMOVE;
		   table[i].flag = 0;
           table[i].depth = 0;
           table[i].score = belowmate;
   }
}


void cHashtable::says_stats()
{
#ifdef DEBUG
    cout<<"\n Hash table: ";
    cout<<" write: "<<write<<" probe: "<<probe<<" hit: "<<hit;
    cout<<"\nhit success "<<percent(hit,hit+probe)<<"%";
    cout<<"\n% elements written from total = ";
    cout<<percent(write,elements)<<"%";
#endif
    if(logger.islog())
    {
      logger.file<<"\n Hash table: ";
      logger.file<<" write: "<<write<<" probe: "<<probe<<" hit: "<<hit;
    logger.file<<"\nhit success "<<percent(hit,hit+probe)<<"%";
    logger.file<<"\n% elements written from total = ";
    logger.file<<percent(write,elements)<<"%\n";
    }
}


void cHashtable::store_hashentry(const int score, const uint flag, const uint move, const int depth, const u64 &key)
{
     ASS(score>=-matescore&&score<=matescore);
     ASS(depth<int(maxply)&&depth>0);
     ASS(flag==tFlagUPPER||flag==tFlagLOWER||flag==tFlagEXACT);
#ifdef DEBUG
uint sparemove = move;
     ASS( (onbrd(FROM(sparemove))&&onbrd(TO(sparemove))) || move==NULLMOVE );
#endif

     //make a pointer to assign to point at a table element
     sHashelem *pElem;
     pElem = table + (key % elements);

	 if(pElem->depth <= depth)
	 {
	   write++;
       pElem->key = key;
       pElem->depth = depth;
	   pElem->flag = flag;
       pElem->move = move;
	   pElem->score = score;
	 }
}


uint cHashtable::probe_hashentry(int &score, const int depth, uint &move, const int &beta, bool &cannull, const u64 &key, const uint ply)
{
     ASS(depth<int(maxply)&&depth>0);
     ASS(ply>0&&ply<maxply);

     sHashelem *pElem;
     pElem = table + (key % elements);

     probe++;

     uint flag = tFlagNOTSET;

     if( pElem->key == key)
     {
      hit++;
      move = pElem->move;
      if(pElem->flag == tFlagUPPER && pElem->score < beta)
      cannull = false;
	  if(pElem->depth >= depth)
	  {
	   score = pElem->score;
	   flag = pElem->flag;
       ASS(score>=-matescore&&score<=matescore);
       ASS(flag!=tFlagNOTSET && (flag&(tFlagUPPER|tFlagLOWER|tFlagEXACT)));
       if (abs(score) > (matescore-200))
       {
	        if (score > 0)
	        score -= ply;
	        else
	        score += ply;
       }
      }
#ifdef DEBUG
        if(flag==tFlagLOWER||flag==tFlagEXACT) ASS(onbrd(FROM(move))&&onbrd(TO(move)));
        else if(flag==tFlagUPPER) ASS(move==NULLMOVE);
        else ASS( onbrd(FROM(move))&&onbrd(TO(move)) || move==NULLMOVE);
#endif
    }

    return flag;

}


